<?php
// Obtiene los datos de la conexión a la BD
require "../config.php";

// Funcion para informar el progreso del proceso
header('Content-Type: text/event-stream');
// recommended to prevent caching of event data.
header('Cache-Control: no-cache'); 
 
function send_message($id, $message, $progress) {
    $d = array('evento' => $message , 'decripcion' => $progress);
     
    echo "fila: $id" . PHP_EOL;
    echo "dato: " . json_encode($d) . PHP_EOL;
    echo PHP_EOL;
     
    ob_flush();
    flush();
}

// Inicia el proceso de carga. Se conecta a la BD
$pdo = new PDO(
  "mysql:host=".$dbHost.";dbname=".$dbName.";charset=".$dbChar,
  $dbUser, $dbPass, [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

// Abre el archivo CSV
$fh = fopen($_FILES["upcsv"]["tmp_name"], "r");
if ($fh === false) { exit("No se pudo abrir el archivo CSV seleccionado"); }

// Lee cada renglón
$salta= 0;
$nfilas=0;
while (($row = fgetcsv($fh)) !== false) {
  //print_r($row);
  if ($salta !== 0) {
	$fecha1= DateTime::createFromFormat('d/m/Y', $row[0]);
	$fecha_hora1= $fecha1->format('Y-m-d') . " " . $row[1];
	$fecha2= DateTime::createFromFormat('d/m/Y', $row[3]);
	$fecha_hora2= $fecha2->format('Y-m-d')  . " " .  $row[4];
	$stmt = $pdo->prepare("INSERT INTO `eventos` (`evt_id`,`evt_desc`,`evt_inicio`,`evt_fin`,`evt_tipo_actividad`,`evt_status`,`evt_salon`,	`negocio_id`,`evt_tipo`,`evt_clase`,`evt_representante`,`evt_coordinador`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
	$stmt->execute([$row[5], $row[6],$fecha_hora1,$fecha_hora2,$row[2],$row[7],$row[8],$row[9],$row[10],$row[11],$row[12],$row[13]]);
	$residuo= fmod($nfilas,100);
	if ($residuo == 0) {echo $nfilas . " filas guardadas..." . PHP_EOL;
	send_message($nfilas, 'Evento ' . $row[5] . ' ' , $row[6]); }
	$nfilas= $nfilas+ 1;
 }
  $salta= 1; 
}
fclose($fh);
echo "FIN DEL PROCESO" . PHP_EOL;
echo $nfilas . " filas guardadas con datos de eventos";
